/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
struct Data // custom data structure
{
   Byte bytes[100];
   Int  integer;
   Flt  value;
};
/******************************************************************************/
// memory containers
Memb<Data> memb; // block based
Meml<Data> meml; // list  based
/******************************************************************************/
void InitPre()
{
   App.name="Memory";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   // adding elements
   {
      // Memb
      {
         Data &data=memb.New();
         data.integer=5;
      }
      // Meml
      {
         Data &data=meml.New();
         data.integer=5;
      }
   }

   // iterating through all elements
   {
      // Memb
      for(Int i=0; i<memb.elms(); i++)
      {
         Data &d=memb[i];
      }
      // Memb through better macro
      FREPA(memb)
      {
         Data &d=memb[i];
      }

      // Meml
      for(Memn *i=meml.first; i; i=i->next)
      {
         Data &d=meml[i];
      }
      // Meml through macro
      MFREP(meml) // please note that here 'i' is not an 'Int' but a 'Memn*'
      {
         Data &d=meml[i];
      }
   }

   // removing elements
   {
      // Memb
      {
         memb.remove(0,true); // remove 0th element, second parameter determines keeping order (read more in the header)
      }
      // Meml
      {
         meml.remove(meml.first);
      }
   }

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
}
/******************************************************************************/
